# PerfectFit Resume Builder

An AI-powered desktop application that analyzes your resume against job descriptions and generates tailored resumes optimized for ATS (Applicant Tracking Systems).

## Features

- ** Dual Score System**: See your original resume score AND your optimized resume score
- ** Keyword Optimization**: Automatically identifies and integrates job-specific keywords
- ** Comprehensive PDF Export**: Export beautifully formatted PDFs with bold keywords
- ** Powered by GPT-4**: Uses advanced AI for in-depth resume analysis and generation
- ** ATS-Optimized**: Generates resumes designed to pass Applicant Tracking Systems
- ** Desktop Application**: Native Electron app for Windows, Mac, and Linux

## How It Works

1. **Upload Your Resume** - Select your current resume (PDF or DOCX) - shows visual confirmation with checkmark
2. **Paste Job Description** - Add the full job posting you're applying for
3. **Get Initial Score** - See how your current resume matches the job requirements
4. **Receive Tailored Resume** - Get a comprehensive, keyword-optimized resume with **bold** keywords
5. **See Improvement** - Compare before and after scores side by side

## Installation

### Prerequisites
- Node.js 18 or higher
- npm or yarn
- OpenAI API key

### Setup

```bash
# Clone the repository
git clone <repository-url>
cd PerfectFit_ResumeBuilder

# Install dependencies
npm install

# Create .env file with your OpenAI API key
# Add: OPENAI_API_KEY=your-api-key-here

# Run the application
npm start
```

### Build for Distribution

```bash
# Build for Windows
npm run dist:win

# Build for Mac
npm run dist:mac

# Build for Linux
npm run dist:linux
```

## Configuration

Create a `.env` file in the root directory:

```env
OPENAI_API_KEY=your-openai-api-key
```

**Note**: This application uses GPT-4-turbo-preview for enhanced resume generation quality.

## Tech Stack

- **Electron** - Desktop application framework
- **OpenAI GPT-4** - AI-powered analysis and generation
- **PDFKit** - PDF document generation
- **pdf-parse** - PDF text extraction
- **Mammoth** - DOCX text extraction

## License

MIT License
