const { contextBridge, ipcRenderer } = require("electron");

contextBridge.exposeInMainWorld("electronAPI", {
  selectFile: () => ipcRenderer.invoke("select-file"),
  analyzeResume: (data) => ipcRenderer.invoke("analyze-resume", data),
  savePDF: (data) => ipcRenderer.invoke("save-pdf", data),
  saveHTML: (data) => ipcRenderer.invoke("save-html", data),
  saveDOCX: (data) => ipcRenderer.invoke("save-docx", data),
  saveMarkdown: (data) => ipcRenderer.invoke("save-markdown", data),
  saveText: (data) => ipcRenderer.invoke("save-text", data),
  showContextMenu: () => ipcRenderer.invoke("show-context-menu"),
  onPaste: (callback) => ipcRenderer.on("context-menu-paste", callback),
  getPDFStyles: () => ipcRenderer.invoke("get-pdf-styles"),
  generatePreviewHTML: (data) =>
    ipcRenderer.invoke("generate-preview-html", data),
});
